<?php
// Expire pending orders older than 48 hours and optionally mark related licenses rejected
define('DSACHECK_ACTIVE', true);
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/database.php';

try {
    // Find orders that are still pending and older than 48 hours
    $stmt = $db->prepare("SELECT code FROM orders WHERE status = 'pending' AND created_at < DATE_SUB(NOW(), INTERVAL 48 HOUR)");
    $stmt->execute();
    $orders = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (!empty($orders)) {
        // Mark orders as 'false'
        $in = str_repeat('?,', count($orders) - 1) . '?';
        $upd = $db->prepare("UPDATE orders SET status = 'false' WHERE code IN ($in)");
        $upd->execute($orders);

        // Mark related licenses as rejected (set rejected_at)
        $upd2 = $db->prepare("UPDATE licenses SET rejected_at = NOW() WHERE order_code IN ($in) AND rejected_at IS NULL");
        $upd2->execute($orders);

        error_log('[dsacheck] Expire job: marked ' . count($orders) . " orders as false and related licenses rejected.");
    } else {
        error_log('[dsacheck] Expire job: no pending orders older than 48 hours.');
    }
} catch (Exception $e) {
    error_log('[dsacheck] Expire job error: ' . $e->getMessage());
    exit(1);
}

exit(0);
