<?php
// Audit licenses for duplicates and suspicious usage.
// Reports license/order codes that are used on more than one distinct domain.
define('DSACHECK_ACTIVE', true);
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/database.php';

try {
    // Find order_codes that map to more than one distinct domain
    $sql = "SELECT order_code, COUNT(DISTINCT domain) AS domains_count, GROUP_CONCAT(DISTINCT domain) AS domains
            FROM licenses WHERE order_code IS NOT NULL GROUP BY order_code HAVING domains_count > 1";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!empty($rows)) {
        foreach ($rows as $r) {
            $msg = sprintf("[dsacheck][audit] Duplicate order_code=%s used on %d domains: %s", $r['order_code'], $r['domains_count'], $r['domains']);
            error_log($msg);
        }
    } else {
        error_log('[dsacheck][audit] No duplicate order_code usages found.');
    }

    // Also check license_key duplicates across domains
    $sql2 = "SELECT license_key, COUNT(DISTINCT domain) AS domains_count, GROUP_CONCAT(DISTINCT domain) AS domains
             FROM licenses GROUP BY license_key HAVING domains_count > 1";
    $stmt2 = $db->prepare($sql2);
    $stmt2->execute();
    $rows2 = $stmt2->fetchAll(PDO::FETCH_ASSOC);
    if (!empty($rows2)) {
        foreach ($rows2 as $r) {
            $msg = sprintf("[dsacheck][audit] Duplicate license_key=%s used on %d domains: %s", $r['license_key'], $r['domains_count'], $r['domains']);
            error_log($msg);
        }
    } else {
        error_log('[dsacheck][audit] No duplicate license_key usages found.');
    }

} catch (Exception $e) {
    error_log('[dsacheck][audit] Error: ' . $e->getMessage());
    exit(1);
}

exit(0);
