<?php
if (!defined('DSACHECK_ACTIVE')) {
    die('Direct access not allowed');
}

try {
    $db = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASSWORD,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    die('Database connection failed: ' . $e->getMessage());
}

// ساختار دیتابیس
$db_structure = [
    // جدول سفارش‌ها
    "CREATE TABLE IF NOT EXISTS orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        code VARCHAR(8) NOT NULL UNIQUE,
        used BOOLEAN DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )",
    
    // جدول لایسنس‌ها
    "CREATE TABLE IF NOT EXISTS licenses (
        id INT AUTO_INCREMENT PRIMARY KEY,
        domain VARCHAR(255) NOT NULL,
        order_code VARCHAR(8) NOT NULL,
        license_key VARCHAR(64) NOT NULL UNIQUE,
        plugin_key VARCHAR(32) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (order_code) REFERENCES orders(code)
    )",
    
    // ایندکس‌ها
    "CREATE INDEX IF NOT EXISTS idx_license_domain ON licenses(domain)",
    "CREATE INDEX IF NOT EXISTS idx_license_key ON licenses(license_key)",
    "CREATE INDEX IF NOT EXISTS idx_order_code ON orders(code)"
];

// ایجاد جداول
foreach ($db_structure as $query) {
    try {
        $db->exec($query);
    } catch (PDOException $e) {
        die('Database structure creation failed: ' . $e->getMessage());
    }
}