<?php
// Simple admin panel with session login, bulk codes form and registrations list
define('DSACHECK_ACTIVE', true);
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/database.php';
require_once __DIR__ . '/includes/functions.php';

session_start();

// Login handling
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    session_destroy();
    header('Location: admin_panel.php');
    exit;
}

$logged = !empty($_SESSION['ds_admin_logged']);
$message = '';

if (!$logged && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login_user'])) {
    $u = $_POST['login_user'];
    $p = $_POST['login_pass'];
    if ($u === ADMIN_USER && $p === ADMIN_PASSWORD) {
        $_SESSION['ds_admin_logged'] = true;
        $logged = true;
    } else {
        $message = 'Invalid credentials';
    }
}

// Actions (bulk import, change status)
if ($logged && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bulk_codes'])) {
    $codes_raw = $_POST['bulk_codes'];
    $plugin_key = $_POST['plugin_key'] ?? 'dsa_image_uploader';
    $lines = preg_split('/\r?\n/', $codes_raw);
    $results = [];
    foreach ($lines as $line) {
        $code = trim($line);
        if ($code === '') continue;
        $code = preg_replace('/\s+/', '', $code);
        // reuse existing admin logic: check order
        $res = check_order_code($code);
        if ($res['success']) {
            $order = $res['data'];
            if ($order['status'] === 'pending') {
                $db->prepare("UPDATE orders SET status='approved', used=1 WHERE code=?")->execute([$code]);
                $results[] = "$code => approved";
            } else {
                $results[] = "$code => no change (status={$order['status']})";
            }
        } else {
            // insert disabled order
            $db->prepare("INSERT INTO orders (code, status, used, created_at) VALUES (?, 'disabled', 0, NOW())")->execute([$code]);
            $results[] = "$code => inserted disabled";
        }
    }
    $message = implode('<br/>', array_map('htmlspecialchars', $results));
}

if ($logged && isset($_GET['act']) && isset($_GET['id'])) {
    $act = $_GET['act'];
    $id = intval($_GET['id']);
    // find license by id
    $stmt = $db->prepare("SELECT * FROM licenses WHERE id = ?");
    $stmt->execute([$id]);
    $lic = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($lic) {
        if ($act === 'approve') {
            // set orders.status = approved if linked
            if (!empty($lic['order_code'])) {
                $db->prepare("UPDATE orders SET status='approved', used=1 WHERE code=?")->execute([$lic['order_code']]);
            }
            $db->prepare("UPDATE licenses SET approved_at = NOW(), pending_expires_at = NULL, rejected_at = NULL WHERE id = ?")->execute([$id]);
            $message = 'License approved';
        } elseif ($act === 'reject') {
            if (!empty($lic['order_code'])) {
                $db->prepare("UPDATE orders SET status='false' WHERE code=?")->execute([$lic['order_code']]);
            }
            $db->prepare("UPDATE licenses SET rejected_at = NOW() WHERE id = ?")->execute([$id]);
            $message = 'License rejected';
        } elseif ($act === 'make_pending') {
            if (!empty($lic['order_code'])) {
                $db->prepare("UPDATE orders SET status='pending' WHERE code=?")->execute([$lic['order_code']]);
            }
            $db->prepare("UPDATE licenses SET pending_expires_at = DATE_ADD(NOW(), INTERVAL 24 HOUR), approved_at = NULL, rejected_at = NULL WHERE id = ?")->execute([$id]);
            $message = 'License set to pending';
        }
    }
}

// Render page
?><!doctype html>
<html lang="fa">
<head>
<meta charset="utf-8">
<title>DSA License Admin</title>
<style>body{font-family:sans-serif;direction:rtl}table{border-collapse:collapse;width:100%}td,th{border:1px solid #ddd;padding:8px}</style>
</head>
<body>
<h1>پنل مدیریت لایسنس</h1>
<?php if ($message): ?><div style="padding:8px;background:#eef;margin-bottom:10px"><?php echo $message; ?></div><?php endif; ?>
<?php if (!$logged): ?>
    <h2>ورود</h2>
    <form method="post">
        <label>نام کاربری: <input type="text" name="login_user" /></label><br/>
        <label>رمز عبور: <input type="password" name="login_pass" /></label><br/>
        <button type="submit">ورود</button>
    </form>
<?php else: ?>
    <p><a href="?action=logout">خروج</a></p>
    <h2>افزودن/تأیید کدها</h2>
    <form method="post">
        <label>کدها (هر خط یک کد):<br/><textarea name="bulk_codes" rows=6 cols=60></textarea></label><br/>
        <label>Plugin key: <input type="text" name="plugin_key" value="dsa_image_uploader" /></label><br/>
        <button type="submit">ثبت و پردازش</button>
    </form>

    <h2>لیست رجیسترها</h2>
    <table>
        <thead><tr><th>ID</th><th>دامنه</th><th>کد سفارش</th><th>license_key</th><th>pending_expires_at</th><th>approved_at</th><th>rejected_at</th><th>عملیات</th></tr></thead>
        <tbody>
        <?php
        $rows = $db->query("SELECT * FROM licenses ORDER BY created_at DESC LIMIT 200")->fetchAll(PDO::FETCH_ASSOC);
        foreach ($rows as $r) {
            echo '<tr>';
            echo '<td>' . intval($r['id']) . '</td>';
            echo '<td>' . htmlspecialchars($r['domain']) . '</td>';
            echo '<td>' . htmlspecialchars($r['order_code']) . '</td>';
            echo '<td style="font-family:monospace">' . htmlspecialchars($r['license_key']) . '</td>';
            echo '<td>' . htmlspecialchars($r['pending_expires_at']) . '</td>';
            echo '<td>' . htmlspecialchars($r['approved_at']) . '</td>';
            echo '<td>' . htmlspecialchars($r['rejected_at']) . '</td>';
            echo '<td>';
            echo '<a href="?act=approve&id=' . intval($r['id']) . '">تأیید</a> | ';
            echo '<a href="?act=reject&id=' . intval($r['id']) . '">رد</a> | ';
            echo '<a href="?act=make_pending&id=' . intval($r['id']) . '">موقت</a>';
            echo '</td>';
            echo '</tr>';
        }
        ?>
        </tbody>
    </table>

<?php endif; ?>
</body>
</html>
