<?php
define('DSACHECK_ACTIVE', true);
require_once 'config.php';
require_once 'includes/database.php';
require_once 'includes/functions.php';

// Simple admin page to bulk import/approve order codes.
// Protect using API_SECRET_KEY passed via POST field 'secret'.

function render_form($message = '') {
    $secret = '';
    echo "<html><head><meta charset=\"utf-8\"><title>License Admin</title></head><body style=\"font-family:Arial, sans-serif;padding:20px;\">";
    if ($message) echo "<div style=\"padding:10px;background:#eef;border:1px solid #99c;margin-bottom:12px;\">" . $message . "</div>";
    echo "<h2>Bulk approve/import order codes</h2>";
    echo "<p>Enter one order code per line. For each code:<br>- if order exists → create/approve license and mark order used;<br>- if order does not exist → create a pending license.</p>";
    echo "<form method=\"post\">";
    echo "<label>Admin secret: <input type=\"password\" name=\"secret\" style=\"width:300px\" /></label><br/><br/>";
    echo "<label>Order codes (one per line):<br/><textarea name=\"codes\" rows=8 cols=60></textarea></label><br/><br/>";
    echo "<label>Plugin key (optional): <input type=\"text\" name=\"plugin_key\" value=\"dsa_image_uploader\" /></label><br/><br/>";
    echo "<button type=\"submit\">Process codes</button>";
    echo "</form></body></html>";
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    render_form();
    exit;
}

$secret = $_POST['secret'] ?? '';
if (empty($secret) || $secret !== API_SECRET_KEY) {
    render_form('Unauthorized: invalid secret.');
    exit;
}

$codes_raw = $_POST['codes'] ?? '';
$plugin_key = $_POST['plugin_key'] ?? 'dsa_image_uploader';
if (empty(trim($codes_raw))) {
    render_form('No codes provided.');
    exit;
}

$lines = preg_split('/\r?\n/', $codes_raw);
$results = [];
foreach ($lines as $line) {
    $code = trim($line);
    if ($code === '') continue;

    // Normalize code
    $code = preg_replace('/\s+/', '', $code);

    // Check orders
    $stmt = $db->prepare("SELECT * FROM orders WHERE code = ?");
    $stmt->execute([$code]);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($order) {
        // If order exists and is 'pending', change it to 'approved'. Otherwise leave as-is.
        if ($order['status'] === 'pending') {
            $db->prepare("UPDATE orders SET status = 'approved', used = 1 WHERE code = ?")->execute([$code]);
            $results[] = "$code => status changed from pending to approved";
        } else {
            $results[] = "$code => already exists with status: " . $order['status'];
        }
        continue;
    }

    // Order not found: create as 'disabled' (admin pre-added)
    $ins = $db->prepare("INSERT INTO orders (code, status, used, created_at) VALUES (?, 'disabled', 0, NOW())");
    $ins->execute([$code]);
    $results[] = "$code => inserted into orders with status 'disabled'";
}

$msg = implode("<br />", array_map('htmlspecialchars', $results));
render_form($msg);

?>
