Server scheduling and cron setup

This folder contains two helper scripts and an optional MySQL EVENT to implement server-side scheduled tasks for the licensing system.

Files:
- scripts/expire_pending.php
  - Marks `orders` with status='pending' older than 48 hours as 'false' and marks related licenses as rejected.
  - Run every 1 hour (recommended).

- scripts/audit_licenses.php
  - Scans `licenses` for duplicate usage of `order_code` or `license_key` across multiple domains and logs findings.
  - Run every 6 or 24 hours.

- db-events.sql
  - Optional MySQL EVENT that performs the 48-hour expiry inside the DB server. Requires `event_scheduler=ON`.

How to run (Linux cron):
1) Make sure PHP CLI is available (php) and has access to the project files.
2) Add cron entries (edit crontab with `crontab -e`):

# expire pending orders every hour
0 * * * * /usr/bin/php "F:/PLUGIN/image uploader/server/scripts/expire_pending.php" >> /var/log/dsacheck_cron.log 2>&1

# audit licenses every 6 hours
0 */6 * * * /usr/bin/php "F:/PLUGIN/image uploader/server/scripts/audit_licenses.php" >> /var/log/dsacheck_audit.log 2>&1

(Adjust PHP path and file paths for Windows vs Linux; on Windows use Task Scheduler with a PowerShell action to run php.exe.)

Windows Task Scheduler example (PowerShell action):
Action: Start a program
Program/script: C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe
Add arguments: -NoProfile -ExecutionPolicy Bypass -Command "& 'C:\path\to\php.exe' 'F:\PLUGIN\image uploader\server\scripts\expire_pending.php'"

Security notes:
- Ensure these scripts are not web-accessible. Keep them outside of any publicly served directory or protect via web server rules.
- Logs are written via PHP error_log; ensure error logging is configured appropriately.

Admin notification:
- Consider wiring audit findings to email or admin dashboard notifications.

*** End of README
